/*
  Wireless Grapher version 0.5
  Copyright 2005-2007 Jeffrey Nelson (nelsonjm@vt.edu). All rights reserved.
*/

// Dirty global variables.
var canvas;
var context;
var button;
var statusText;
var timerInterval = 1;
var backgroundUpdates = false;
var timer;
var width = 300; // Width of graph
var height = 150; // height of graph
var blocksize = 5; // Size of bar, 5 is nice because it overlaps slightly to make a greenish glow between samples.
var adjust = 0; // used for adjusting graph.
var buffer = 1; // used to make sure the graph is filled up.
var linkData;
var commsData;


// setup() is run when the body loads.  It checks to see if there is a preference for this widget
// and if so, applies the preference to the widget.
function setup()
{

	var doneButton = document.getElementById('done');
	createGenericButton(doneButton, getLocalizedString('Done'), doneMouseUp);

	if(window.widget) // Make sure you are running in Dashboard
	{
		// get and set preferences
		timerInterval = widget.preferenceForKey("timerInterval");
		if (isNaN(timerInterval) || timerInterval > 10 || timerInterval < 1) {
			document.getElementById("timerPopup").selectedIndex = 0;
			timerInterval = 1;
		} else {
			document.getElementById("timerPopup").selectedIndex = timerInterval;
			timerInterval += 1;
		}
	
		backgroundUpdates = widget.preferenceForKey("backgroundUpdates");
		document.getElementById("backgroundUpdates").checked = backgroundUpdates;
		
		// find canvas and make context for drawing.
		canvas = document.getElementById("canvas");
		context = canvas.getContext("2d");
	
		// find button and status text portions of html
		button = document.getElementById("button");
		statusText = document.getElementById("statusText");
		
		document.getElementById("statusText").innerHTML = getLocalizedString('Information Unavaliable');
		document.getElementById("updateTimerText").innerHTML = getLocalizedString('Update every:');
		document.getElementById("updateHiddenText").innerHTML = getLocalizedString('Update while hidden');
		
		// create the data array and set elements to zero.
		linkData = new Array(Math.round(width/blocksize) + buffer);
		commsData = new Array(Math.round(width/blocksize) + buffer);
		var x;
		for (x=0; x < linkData.length; x++)
		{
		  	linkData[x] = 0;
		  	commsData[x] = 0;
		}
		timer = null;

		widget.onshow = startTimer;
		
		if (!backgroundUpdates)
		{
			widget.onhide = stopTimer;
		}
	}	
}

// Get localized strings stuff.
function getLocalizedString (key)
{
	try {
		return localizedStrings[key];
	} catch (ex) {}

	return key;
}


// Starts timer so interface is updated.
function startTimer()
{
	if ( timer != null )
	{
		clearInterval( timer );
		timer = null;
	}
	if (isNaN(timerInterval) || timerInterval > 10 || timerInterval < 1) {
		timerInterval = 1;
	}
	timer = setInterval("updateData();", 1000 * timerInterval);
}

// Stops timer so interface is not updated.
function stopTimer()
{
	if ( timer != null )
	{
		clearInterval( timer );
		timer = null;
	}
}



// Update button, graph, and text.
function updateData()
{
	//alert ("timer!");
	if (!WirelessGrapherPlugin) {
		button.innerHTML = '<img src="images/button_red.png"/>';
		statusText.innerHTML = getLocalizedString('Error loading plugin.');	
		return;
	} 
	
	// Update the wireless sample and remove the oldest data entries.
	WirelessGrapherPlugin.updateSample();
	linkData.shift();
	commsData.shift();
	
	// Add new sample data, update the button and interface.
	if (!WirelessGrapherPlugin.validSample()) { // Error
		linkData.push(0);
		commsData.push(0);		
		button.innerHTML = '<img src="images/button_red.png"/>';
		statusText.innerHTML = getLocalizedString('Error reading wireless data.');
	} else if (!WirelessGrapherPlugin.powerState()) { // Power Off
		linkData.push(0);
		commsData.push(0);	
		button.innerHTML = '<img src="images/button_gray.png"/>';
		statusText.innerHTML = getLocalizedString('Wireless power not on.');
	} else if (!WirelessGrapherPlugin.wirelessConnectionAvaliable() || WirelessGrapherPlugin.APName() == '') { // Not connected
		linkData.push(0);
		commsData.push(0);	
		button.innerHTML = '<img src="images/button_yellow.png"/>';
		statusText.innerHTML = getLocalizedString('Not connected.');
	} else { // Connected
		linkData.push(WirelessGrapherPlugin.linkQual());
		commsData.push(WirelessGrapherPlugin.commsQual());
		//alert(linkData[x] + ", " + commsData[x]);
		button.innerHTML = '<img src="images/button_green.png"/>';
		statusText.innerHTML = getLocalizedString('Network: ') + WirelessGrapherPlugin.APName();
		if (WirelessGrapherPlugin.Channel() != -1)
			 statusText.innerHTML += ' Channel: ' + WirelessGrapherPlugin.Channel();
	}
	
	
	// Clear graph and redraw the data.
	context.clearRect(0,0,width,height);
	var x;
	for (x=0; x < linkData.length; x++) // Draw the bars
	{
	        var linkBarHeight = (height/ 100) * linkData[x];
	        if (linkBarHeight > height)
	        	linkBarHeight = height;
	        var linkBarOffset = height - linkBarHeight; 
	  		context.fillStyle = 'rgba(64, 64, 255, .5)'; // Link quality bar 
			context.fillRect(x * blocksize - adjust, linkBarOffset, width/50, linkBarHeight);
	        var commsBarHeight = (height/ 100) * commsData[x];
	        if (commsBarHeight > height)
	        	commsBarHeight = height;
	        var commsBarOffset = height - commsBarHeight;
	        
			context.fillStyle = 'rgba(64, 255, 64, .5)'; // Link communications quality bar
			context.fillRect(x * blocksize - adjust, commsBarOffset, width/50, commsBarHeight);
			context.fillStyle = 'rgba(32, 32, 255, 1)'; // Link quality bar cap
			context.fillRect(x * blocksize - adjust, linkBarOffset, width/50, 2);
			context.fillStyle = 'rgba(32, 255, 32, 1)'; // Link communications bar cap
			context.fillRect(x * blocksize - adjust, commsBarOffset, width/50, 2);
	}

}

// Send them to the website! Or at lest the temporary one.
function logoClick()
{
	if (window.widget)
    {
    	widget.openURL('http://macpod.net');
    }
}

// changeTimer() is called whenever a menu item is chosen in the widget's preferences.  It queries the
// menu to find out which option was chosen, applies the change to the widget, and saves the preference.
function changeTimer(elem)
{		
	if (window.widget) {
		stopTimer();
		if (elem.selectedIndex > 10 || elem.selectedIndex < 1) {
				timerInterval = 1;
				widget.setPreferenceForKey(0, "timerInterval");
		} else {
				timerInterval = elem.selectedIndex + 1;
				widget.setPreferenceForKey(elem.selectedIndex, "timerInterval");
		}
		startTimer();
	}
} 

// changeBackgroundUpdates() is called whenever the checkbox is clicked in the widget's preferences.  It finds the
// state, applies the change to the widget, and saves the preference.
function changeBackgroundUpdates(elem)
{	
	if (window.widget) {
		backgroundUpdates = elem.checked;
		if (!backgroundUpdates)
		{
			widget.onhide = stopTimer;
		} else {
			widget.onhide = null;
		}
		widget.setPreferenceForKey(elem.checked, "backgroundUpdates");
	}
} 




//************************************************************************************************************************
// Code below Copyright 2005 Apple Computer, Inc.
//************************************************************************************************************************

/*********************************/
// DONE BUTTON EVENTS
/*********************************/

function doneMouseUp(event)
{
	var front = document.getElementById("front");
	var back = document.getElementById("back");
	
	if (window.widget)
		widget.prepareForTransition("ToFront");
	
	front.style.display="block";
	
	back.style.display="none";
	if (window.widget)
		setTimeout ('widget.performTransition();', 0);
}

/*********************************/
// HIDING AND SHOWING PREFERENCES
/*********************************/

// showPrefs() is called when the preferences flipper is clicked upon.  It freezes the front of the widget,
// hides the front div, unhides the back div, and then flips the widget over.

function showPrefs()
{
	var front = document.getElementById("front");
	var back = document.getElementById("back");
	
	if (window.widget)
		widget.prepareForTransition("ToBack");		// freezes the widget so that you can change it without the user noticing
	
	front.style.display="none";		// hide the front
	back.style.display="block";		// show the back
	
	if (window.widget)
		setTimeout ('widget.performTransition();', 0);		// and flip the widget over	

	document.getElementById('fliprollie').style.display = 'none';  // clean up the front side - hide the circle behind the info button
}


// hidePrefs() is called by the done button on the back side of the widget.  It performs the opposite transition
// as showPrefs() does.

function hidePrefs()
{
	var front = document.getElementById("front");
	var back = document.getElementById("back");
	
	if (window.widget)
		widget.prepareForTransition("ToFront");		// freezes the widget and prepares it for the flip back to the front
	
	back.style.display="none";			// hide the back
	front.style.display="block";		// show the front
	
	if (window.widget)
		setTimeout ('widget.performTransition();', 0);		// and flip the widget back to the front
}


// PREFERENCE BUTTON ANIMATION (- the pref flipper fade in/out)

var flipShown = false;		// a flag used to signify if the flipper is currently shown or not.


// A structure that holds information that is needed for the animation to run.
var animation = {duration:0, starttime:0, to:1.0, now:0.0, from:0.0, firstElement:null, timer:null};


// mousemove() is the event handle assigned to the onmousemove property on the front div of the widget. 
// It is triggered whenever a mouse is moved within the bounds of your widget.  It prepares the
// preference flipper fade and then calls animate() to performs the animation.

function mousemove(event)
{
	if (!flipShown)			// if the preferences flipper is not already showing...
	{
		if (animation.timer != null)			// reset the animation timer value, in case a value was left behind
		{
			clearInterval (animation.timer);
			animation.timer  = null;
		}
		
		var starttime = (new Date).getTime() - 13; 		// set it back one frame
		
		animation.duration = 500;												// animation time, in ms
		animation.starttime = starttime;										// specify the start time
		animation.firstElement = document.getElementById ('flip');		// specify the element to fade
		animation.timer = setInterval ("animate();", 13);						// set the animation function
		animation.from = animation.now;											// beginning opacity (not ness. 0)
		animation.to = 1.0;														// final opacity
		animate();																// begin animation
		flipShown = true;														// mark the flipper as animated
	}
}

// mouseexit() is the opposite of mousemove() in that it preps the preferences flipper
// to disappear.  It adds the appropriate values to the animation data structure and sets the animation in motion.

function mouseexit(event)
{
	if (flipShown)
	{
		// fade in the flip widget
		if (animation.timer != null)
		{
			clearInterval (animation.timer);
			animation.timer  = null;
		}
		
		var starttime = (new Date).getTime() - 13;
		
		animation.duration = 500;
		animation.starttime = starttime;
		animation.firstElement = document.getElementById ('flip');
		animation.timer = setInterval ("animate();", 13);
		animation.from = animation.now;
		animation.to = 0.0;
		animate();
		flipShown = false;
	}
}


// animate() performs the fade animation for the preferences flipper. It uses the opacity CSS property to simulate a fade.

function animate()
{
	var T;
	var ease;
	var time = (new Date).getTime();
		
	
	T = limit_3(time-animation.starttime, 0, animation.duration);
	
	if (T >= animation.duration)
	{
		clearInterval (animation.timer);
		animation.timer = null;
		animation.now = animation.to;
	}
	else
	{
		ease = 0.5 - (0.5 * Math.cos(Math.PI * T / animation.duration));
		animation.now = computeNextFloat (animation.from, animation.to, ease);
	}
	
	animation.firstElement.style.opacity = animation.now;
}


// these functions are utilities used by animate()

function limit_3 (a, b, c)
{
    return a < b ? b : (a > c ? c : a);
}

function computeNextFloat (from, to, ease)
{
    return from + (to - from) * ease;
}

// these functions are called when the info button itself receives onmouseover and onmouseout events

function enterflip(event)
{
	document.getElementById('fliprollie').style.display = 'block';
}

function exitflip(event)
{
	document.getElementById('fliprollie').style.display = 'none';
}